@extends('layouts.app')

@section('title', 'Lupa Password - IDN Menulis')

@section('content')
<main class="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-indigo-100 py-12 px-4">
    <div class="w-full max-w-md bg-white rounded-lg shadow-md p-8">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-bold text-gray-900">IDN Menulis</h1>
            <p class="text-gray-600 mt-2">Platform Literasi Digital untuk Siswa Indonesia</p>
        </div>

        <h2 class="text-2xl font-bold text-center mb-2 text-gray-800">Lupa Password?</h2>
        <p class="text-center text-gray-600 mb-6">Masukkan email Anda untuk mereset password</p>

        @if ($errors->any())
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                @foreach ($errors->all() as $error)
                    <p>{{ $error }}</p>
                @endforeach
            </div>
        @endif

        @if (session('status'))
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                {{ session('status') }}
            </div>
        @endif

        <form method="POST" action="{{ route('password.request') }}" class="space-y-4">
            @csrf

            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                <input
                    type="email"
                    name="email"
                    id="email"
                    value="{{ old('email') }}"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('email') border-red-500 @enderror"
                    required
                >
                @error('email')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <button
                type="submit"
                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-lg transition duration-200"
            >
                Kirim Link Reset
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-gray-600">Kembali ke <a href="{{ route('login') }}" class="text-blue-600 hover:underline font-semibold">halaman login</a></p>
        </div>
    </div>
</main>

@endsection
